#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

typedef struct {
    double x;
    double h;
    int original_index;
} Jarbol;

int poredi_jarbole(const void *a, const void *b) {
    double xa = ((Jarbol*)a)->x;
    double xb = ((Jarbol*)b)->x;
    if (xa < xb) return -1;
    if (xa > xb) return 1;
    return 0;
}

double distanca(double x1, double y1, double x2, double y2){
    return sqrt(pow(x1-x2,2)+pow(y1-y2,2));
}

double nadji_najmanje(double xa,double ha,double xb,double hb,double xv,double hv){
    double hp=(ha+hb-(xb-xa))/2.0;
    double xp=xa+(ha-hp);
    double min_d=FLT_MAX;
    int nadjeno=0;

    if(hp>=hv){
        double d=distanca(xp,hp,xv,hv);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    double x_levo=xa+ha-hv;
    if(x_levo>=xa && x_levo<=xp){
        double d=fabs(xv-x_levo);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    double x_desno=xb-(hb-hv);
    if(x_desno>=xp && x_desno<=xb){
        double d=fabs(xv-x_desno);
        if(d<min_d)min_d=d;
        nadjeno=1;
    }

    if(nadjeno){
        return min_d;
    }else{
        return FLT_MAX;
    }
}

int main(){
    int n;
    if(scanf("%d",&n)!=1)return 1;

    Jarbol *jarboli = (Jarbol*)malloc(n * sizeof(Jarbol));
    if (jarboli == NULL) return 1;

    for(int i=0;i<n;i++){
        if(scanf("%lf",&jarboli[i].x)!=1){free(jarboli);return 1;}
        jarboli[i].original_index = i;
    }
    for(int i=0;i<n;i++){
        if(scanf("%lf",&jarboli[i].h)!=1){free(jarboli);return 1;}
    }
    qsort(jarboli, n, sizeof(Jarbol), poredi_jarbole);
 
    double *rezultati = (double*)malloc(n * sizeof(double));
    if (rezultati == NULL) {free(jarboli); return 1;}
    for(int i=0;i<n;i++){
        double min_d=FLT_MAX;
        double xi=jarboli[i].x;
        double hi=jarboli[i].h;
        int nadjeno=0;

        for(int j=0;j<n;j++){
            if(i==j)continue;
            
            if(jarboli[j].h>=hi){
                double d=distanca(xi,hi,jarboli[j].x,jarboli[j].h);
                if(d<min_d){
                    min_d=d;
                    nadjeno=1;
                }
            }
        }

        if(i>0){
            double d=nadji_najmanje(jarboli[i-1].x,jarboli[i-1].h,jarboli[i].x,jarboli[i].h,xi,hi);
            if(d<min_d){
                min_d=d;
                nadjeno=1;
            }
        }
        if(i<n-1){
            double d=nadji_najmanje(jarboli[i].x,jarboli[i].h,jarboli[i+1].x,jarboli[i+1].h,xi,hi);
            if(d<min_d){
                min_d=d;
                nadjeno=1;
            }
        }

        if(nadjeno){
            rezultati[jarboli[i].original_index] = min_d;
        } else {
            rezultati[jarboli[i].original_index] = -1.0;
        }
    }

    for(int i=0; i<n; i++){
        double min_d = rezultati[i];
        if(min_d < 0){
             printf("-1\n");
        } else {
            if(fabs(min_d-round(min_d))<1e-9){
                printf("%.0f\n",min_d);
            }else{
                printf("%.6f\n",min_d);
            }
        }
    }

    free(jarboli);
    free(rezultati);
    return 0;
}